
/* bproxy.c -- Copyright 1998 Sam Creasey, distributed under the terms
   of the GNU Public Licence, v2 or greater.  Please see the file
   COPYING in this archive for details */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <signal.h>
#include <errno.h>

/* remote addresses to try... */
char *remotes[] = {"10.0.0.3", "10.0.0.30", NULL};

/* size of the message buffer.  setting this higher than the MTU
   should make things work right. */

#define BUFSIZE 2048

/* define for debugging messages */
#undef DEBUG

/* globals */
int insock;
int slen = sizeof(struct sockaddr_in);
struct sockaddr_in listen_str;
int reuse = 1;
int intlen = sizeof(int);

/* protos */
void clean_child(int signal);
void copyloop(int infd, int outfd);
void newconn(void);

main(int ac, char **av) 
{

     int i;
  
     if(ac < 2) {
	  printf("must specify listen port!\n");
	  return 1;
     }

     signal(SIGCHLD, clean_child);
     
     /* set up our listener */

     insock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

     if((listen_str.sin_port = htons(atoi(av[1]))) == 0) {
	  printf("invalid port specified\n");
	  return 1;
     }
     listen_str.sin_family = AF_INET;
     listen_str.sin_addr.s_addr = inet_addr("0.0.0.0");

     if(setsockopt(insock, SOL_SOCKET, SO_REUSEADDR, &reuse, intlen) == -1) {
	  perror("setsockopt");
	  return 1;
     }
     
     if(bind(insock, &listen_str, sizeof(struct sockaddr_in)) == -1) {
	  perror("bind");
	  return 1;
     }

#ifdef DEBUG
     printf("bound listener, fd %d\n", insock);
#endif

     while(1)
	  newconn();

     return 0;

}

/* copyloop -- select()'s forever */
void copyloop(int infd, int outfd) 
{

     int len, len2;
     int sel;
     int maxfd = infd;
     fd_set tmpfds;
     pid_t pid = getpid();
     char buf[BUFSIZE];

     if(outfd > infd)
	  maxfd = outfd;

     while(1) {

	  FD_ZERO(&tmpfds);
	  FD_SET(infd, &tmpfds);
	  FD_SET(outfd, &tmpfds);
  
	  if((sel = select(maxfd+1, &tmpfds, NULL, NULL, NULL)) == -1) {
	       perror("select");
	       exit(1);
	  }
	  
	  if(sel == 0) 
	       exit(0);


#ifdef DEBUG	  
	  printf("pid %d: selected: ", pid);     
#endif
	  if(FD_ISSET(infd, &tmpfds)) {
	       FD_CLR(infd, &tmpfds);
	       len = read(infd, buf, BUFSIZE);
#ifdef DEBUG
	       printf("%d bytes from inside", len);
#endif
	       if(len < 1) {
		    shutdown(outfd, 2);
		    close(infd);
		    close(outfd);
		    exit(0);
	       }
	       write(outfd, buf, len);
	  }
	  
	  if(FD_ISSET(outfd, &tmpfds)) {
	       FD_CLR(outfd, &tmpfds);
	       len = read(outfd, buf, BUFSIZE);
#ifdef DEBUG
	       printf(", %d bytes from outside", len);
#endif
	       if(len < 1) {
		    shutdown(infd, 2);
		    close(infd);
		    close(outfd);
		    exit(0);
	       }
	       write(infd, buf, len);
	  }
	  
#ifdef DEBUG
	  printf("\n");
#endif
     } /* while 1 */
     
}     

/* accept a new connection, bind to listen again, and change insock */
void newconn(void) {

     int new, sel;
     fd_set rfds;

     /* wait for some activity */
#ifdef DEBUG
     printf("Waiting for connection...\n");
#endif

     do {
	  FD_ZERO(&rfds);
	  FD_SET(insock, &rfds);
	  if((sel = select(insock+1, &rfds, NULL, NULL, NULL)) == -1) {
	       if(errno == EINTR) {
		    sel = 0;
		    continue;
	       }
	       perror("select_new");
	       exit(1);
	  }
     } while(sel == 0);
#ifdef DEBUG
     printf("Connected\n");
#endif
     new = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

     /* double fork so we don't have to pick up children */
     if(fork() == 0) {
	  int len;
	  struct sockaddr_in from;
	  char tmpbuf[BUFSIZE];
	  char tmpbuf2[BUFSIZE];
	  struct sockaddr_in to;
	  struct sockaddr_in out;
	  fd_set testfds;
	  struct timeval tv;
	  int stat, i, newrem;
	  
	  newrem = insock;

	  if((len = recvfrom(newrem, tmpbuf, BUFSIZE, 0, &from, &slen)) == -1) {
	       perror("recvfrom");
	       exit(1);
	  }

/*	  newrem = dup(insock); 
	  close(insock); */

#ifdef DEBUG
	  printf("%d bytes out of recvfrom\n", len);
#endif

#ifdef DEBUG
	  printf("from.sin_port: %d\n", ntohs(from.sin_port));
	  printf("from.addr: %s\n", inet_ntoa(from.sin_addr));
	  printf("from.sin_family: %d\n", from.sin_family);
#endif
	  
	  
	  memcpy(&out.sin_addr, &from.sin_addr, sizeof(struct in_addr));
	  out.sin_family = AF_INET;
	  out.sin_port = 0;
	  
/*	  newrem = socket(AF_INET, SOCK_DGRAM, 0); */
	  
	  if(connect(newrem, &from, slen) == -1) {
	       perror("connect");
	       exit(1);
	  }
	  
	  to.sin_port = htons(6112);
	  to.sin_family = AF_INET;
	  
	  if(bind(new, &out, slen) == -1) {
	       perror("bind_new");
	       exit(1);
	  }

	  /* if the other side doesn't respond in 2 seconds, call it a
	     fail and move on... */ 
	  
	  for(i = 0 ; remotes[i] != NULL; i++) {
	       to.sin_addr.s_addr = inet_addr(remotes[i]);
#ifdef DEBUG 
	       printf("trying %s\n", inet_ntoa(to.sin_addr));
#endif
	       if(connect(new, &to, slen) == -1) {
		    perror("connect");
		    exit(1);
	       }

	       FD_ZERO(&testfds);
	       FD_SET(new, &testfds);
	       tv.tv_sec = 3;
	       tv.tv_usec = 0;

	       write(new, tmpbuf, len);
	       if((stat = select(new + 1, &testfds, NULL, NULL, &tv))
		  == 1)
		    break;
	      
	  }
#ifdef DEBUG
	  printf("%d connects\n", stat);
/*	  exit(1); */
#endif

	  
	  if(stat != 1) {
#ifdef DEBUG
	       printf("couldn't find a responsive remote...\n");
#endif
	       shutdown(newrem, 2);
	       shutdown(new, 2);
	       close(newrem);
	       close(new);
	       exit(1);
	  }
	  
#ifdef DEBUG
	  printf("to.sin_port: %d\n", ntohs(to.sin_port));
	  printf("to.addr: %s\n", inet_ntoa(to.sin_addr));
	  printf("to.sin_family: %d\n", to.sin_family);
	  printf("forked -- rem: %d  loc: %d\n", newrem, new);
#endif
	  copyloop(new, newrem);
	  /* not reached */
     } /* child fork */
     sleep(1);
     /* listen again... */
     /* make a new insock */

     close(insock);
     close(new);

     insock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

     if(setsockopt(insock, SOL_SOCKET, SO_REUSEADDR, &reuse, intlen) == -1) {
	  perror("setsockopt");
	  exit(1);
     }

     if(bind(insock, &listen_str, sizeof(struct sockaddr_in)) == -1) {
          perror("bind_new_insock");
          exit(1);
     }

     printf("created new listener, fd: %d\n", insock);
     
     return;

}

void clean_child(int signal)
{

     int status;
     pid_t pid;

     pid = wait(&status);

#ifdef DEBUG
     printf("pid %d cleaned up\n", pid);
#endif
     
     return;

}
