
/* bsimple.c -- Copyright 1998 Sam Creasey, distributed under the
   terms of the GNU Public Licence, v2 or greater.  Please see the
   file COPYING in this archive for details. */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/wait.h>

/* remote addresses to try... */
char *remotes[] = {"10.0.0.3", "10.0.0.30", NULL};

/* size of the message buffer.  setting this higher than the MTU
   should make things work right. */

#define BUFSIZE 2048

/* define for debugging messages */
#undef DEBUG

/* globals */
int insock;
int slen = sizeof(struct sockaddr_in);
struct sockaddr_in listen_str;
int reuse = 1;
int intlen = sizeof(int);

/* protos */
void newconn(void);

main(int ac, char **av) 
{

     int i;
  
     if(ac < 2) {
	  printf("must specify listen port!\n");
	  return 1;
     }
     
     /* set up our listener */

     insock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

     if((listen_str.sin_port = htons(atoi(av[1]))) == 0) {
	  printf("invalid port specified\n");
	  return 1;
     }
     listen_str.sin_family = AF_INET;
     listen_str.sin_addr.s_addr = inet_addr("0.0.0.0");

     if(setsockopt(insock, SOL_SOCKET, SO_REUSEADDR, &reuse, intlen) == -1) {
	  perror("setsockopt");
	  return 1;
     }
     
     if(bind(insock, &listen_str, sizeof(struct sockaddr_in)) == -1) {
	  perror("bind");
	  return 1;
     }

#ifdef DEBUG
     printf("bound listener, fd %d\n", insock);
#endif

     while(1)
	  newconn();

     return 0;

}


/* accept a new connection, bind to listen again, and change insock */
void newconn(void) {

     int len;
     struct sockaddr_in from;
     char tmpbuf[BUFSIZE];
     struct sockaddr_in to;
     struct sockaddr_in out;
     fd_set testfds;
     struct timeval tv;
     int stat, i, newrem, new;

#ifdef DEBUG
     printf("Waiting for connection...\n");
#endif
     
     if((len = recvfrom(insock, tmpbuf, BUFSIZE, 0, &from, &slen)) == -1) {
	       perror("recvfrom");
	       exit(1);
	  }

#ifdef DEBUG
     printf("%d bytes out of recvfrom\n", len);
#endif
     
#ifdef DEBUG
     printf("from.sin_port: %d\n", ntohs(from.sin_port));
     printf("from.addr: %s\n", inet_ntoa(from.sin_addr));
     printf("from.sin_family: %d\n", from.sin_family);
#endif
     
     
     memcpy(&out.sin_addr, &from.sin_addr, sizeof(struct in_addr));
     out.sin_family = AF_INET;
     out.sin_port = 0;
     
     if(connect(insock, &from, slen) == -1) {
	  perror("connect");
	  exit(1);
     }
	  
     to.sin_port = htons(6112);
     to.sin_family = AF_INET;

     new = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
     
     if(bind(new, &out, slen) == -1) {
	  perror("bind_new");
	  exit(1);
     }

     /* try to send packet to every listener... */
     for(i = 0 ; remotes[i] != NULL; i++) {
	  to.sin_addr.s_addr = inet_addr(remotes[i]);
#ifdef DEBUG 
	  printf("trying %s\n", inet_ntoa(to.sin_addr));
#endif
	  if(connect(new, &to, slen) == -1) {
	       perror("connect");
	       exit(1);
	  }
	       write(new, tmpbuf, len);
     }
   
     shutdown(insock, 2);
     shutdown(new, 2);
     close(insock);
     close(new);

     insock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

     if(setsockopt(insock, SOL_SOCKET, SO_REUSEADDR, &reuse, intlen) == -1) {
	  perror("setsockopt");
	  exit(1);
     }

     if(bind(insock, &listen_str, sizeof(struct sockaddr_in)) == -1) {
          perror("bind_new_insock");
          exit(1);
     }

#ifdef DEBUG
     printf("created new listener, fd: %d\n", insock);
#endif
     
     return;

}
