
#include <stdio.h>
#include <unistd.h>
#include <curses.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>

#include "display.h"
#include "vars.h"

static WINDOW *mainwin;
static WINDOW *commwin;
static WINDOW *dirwin;

/* global for the directory structure */
struct ti_dirent *dir = NULL;

/* brings up the ncurses display */

void init_disp(void) {

     initscr();
     immedok(stdscr, TRUE);
     keypad(stdscr, TRUE);
     
     clear();


     mainwin = newwin(LINES-2, COLS, 0, 0);
     commwin = newwin(1, COLS, LINES-1, 0);
/*     dirwin = newwin(LINES-2, (COLS/2)-1, 0, COLS/2); */
     
     /* any NULL means a failure */
     if((mainwin == NULL) || (commwin == NULL)/* || (dirwin == NULL)*/) {
	  endwin();
	  printf("Display initialization failed\n");
	  exit(1);
     }

     immedok(mainwin, TRUE);
     immedok(commwin, TRUE);
     scrollok(mainwin, TRUE);
     scrollok(commwin, FALSE);
     meta(commwin, TRUE);
     keypad(commwin, TRUE);
     cbreak();

     pmain("Display initialized\n");
     
     return;

}

void pcomm(const char *fmt, ...) {

     va_list argptr;

     wclear(commwin);
     wmove(commwin, 0, 0);

     va_start(argptr, fmt);
     vwprintw(commwin, fmt, argptr);
     va_end(argptr);

     return;

}

void pmain(const char *fmt, ...) {

     va_list argptr;

     va_start(argptr, fmt);
     vwprintw(mainwin, fmt, argptr);
     va_end(argptr);

     return;

}

int get_key(void) {
     
     int key;
     
     key = wgetch(commwin);
     
     /* fix metas, esc-key is meta-key */
     if(key == 0x1b) {
	  key = wgetch(commwin);
	  key = (key | 0x80);
     }

     return key;

}

int get_str(char *buf) {

     int ret;

     nocbreak();
     ret = wgetstr(commwin, buf);
     cbreak();

     return ret;

}
