
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>

#include "comm.h"
#include "vars.h"

static void usage(char *arg);
static void to_ti(int infd, char *varname);
static void to_text(int outfd, char *varname);
void pmain(const char *fmt, ...);

/* change this for a 92 */
int calc_model = 89;

main(int ac, char **av) {

     int infd;
     int outfd;

     if(ac < 3) 
	  usage(av[0]);
     

     if((infd = open(av[2], O_RDWR | O_CREAT, S_IRUSR | S_IWUSR)) == -1) {
	  perror("in_open");
	  exit(1);
     }

     if(!strcmp(av[1], "-ti"))
	  to_ti(infd, av[3]);
     else if(!strcmp(av[1], "-text"))
	  to_text(infd, av[3]);
     else
	  printf("must specify -ti or -text\n");

     close(infd);
     
     exit(0);
	 

}

void to_ti(int infd, char *destname) {

     struct stat statbuf;
     char *obuf, *opos;
     char inbuf[100];
     int len, i;
     char conv[4];
     char varname[18];

     if(fstat(infd, &statbuf)) {
	  perror("stat");
	  exit(1);
     }

     /* prepare for conversions */
     memset(conv, 0, 4);

     obuf = alloca(statbuf.st_size+3);
     opos = obuf;

     /* put on leading bytes.. */
     opos[0] = 0;
     opos[1] = 1;
     opos += 2;

     while((len = read(infd, &inbuf, 100)) > 0) {
	  for(i = 0; i < len; i++) {

	       /* fix line ends (expect unix style!) */
	       if(inbuf[i] == '\n') {
		    opos[0] = '\r';
		    opos++;
		    continue;
	       }

	       /* a backslash is gonna signify an escaped ti char */
	       if(inbuf[i] == '\\') {
		    i++;
		    /* 2 is a real \ */
		    if(inbuf[i] == '\\') {
			 opos[0] = '\\';
			 opos++;
			 continue;
		    }

		    strncpy(conv, &inbuf[i], 3);
		    i += 2;
		    opos[0] = atoi(conv);
		    opos++;
		    continue;
	       }

	       /* any other char goes straight through */
	       opos[0] = inbuf[i];
	       opos++;
	  }
     } /* ends while on read */

     /* append end mark */
     opos[0] = 0xe0;
     opos++;
     
     sprintf(varname, "main\\%s", destname);
     save_var(varname, VAR92_TEXT, obuf, (unsigned short)(opos-obuf));

     return;

}

void to_text(int outfd, char *varname) {

     unsigned char *ibuf, *ipos;
     int len;
     char filename[20];
     char folder[20];
     char vname[20];
     int i;
     FILE *out;

     if((out = fdopen(outfd, "w")) == NULL) {
	  perror("fdopen");
	  exit(1);
     }

     sprintf(filename, "%s.%dt", varname, calc_model);

     if((ibuf = load_var(filename, &len, vname, folder)) == NULL) 
	  exit(1);

     /* skip the header bytes */
     ipos = ibuf + 2;

     for(;ipos < (ibuf+len)-1; ipos++) {

	  if(ipos[0] == '\r') {
	       fputc('\n', out);
	       continue;
	  }

	  if((ipos[0] < 32) || (ipos[0] > 126)) {
	       fprintf(out, "\\%.3d", ipos[0]);
	       continue;
	  }

	  fputc(ipos[0], out);
     }

     fclose(out);
     
     return;

}
     
     
void pmain(const char *fmt, ...) {
     
     va_list argptr;
     
     va_start(argptr, fmt);
     vprintf(fmt, argptr);
     va_end(argptr);
     
     return;

}

void usage(char *arg) {

     printf("usage:\t%s <dir> <filename> <varname>\n");
     printf("\t\t--ti convert to variable format\n");
     printf("\t\t--text convert to text file\n");
     printf("filename is the name of the text file\n");
     printf("varname is the name of the variable (w/o extension)\n");
     
     exit(1);

}
